/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.lobbysounds.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickScheduler {
    public static final TickScheduler INSTANCE = new TickScheduler();
    private final List<Task> items = new ArrayList<Task>();

    private TickScheduler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void schedule(int ticksToWait, Runnable runnable) {
        this.items.add(new Task(ticksToWait, runnable));
    }

    @SubscribeEvent
    public void onTickClientTick(TickEvent.ClientTickEvent event) {
        this.items.removeIf(Task::execute);
    }

    private static class Task {
        private final Runnable task;
        private int ticksLeft;

        private Task(int ticksLeft, Runnable runnable) {
            this.ticksLeft = ticksLeft;
            this.task = runnable;
        }

        boolean execute() {
            if (this.ticksLeft <= 0) {
                this.task.run();
                return true;
            }
            --this.ticksLeft;
            return false;
        }
    }
}

